/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Bootstrap;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.world.ForgeWorldPreset;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class ForgeRegistries {
    public static final IForgeRegistry<Block> BLOCKS;
    public static final IForgeRegistry<Fluid> FLUIDS;
    public static final IForgeRegistry<Item> ITEMS;
    public static final IForgeRegistry<MobEffect> MOB_EFFECTS;
    public static final IForgeRegistry<SoundEvent> SOUND_EVENTS;
    public static final IForgeRegistry<Potion> POTIONS;
    public static final IForgeRegistry<Enchantment> ENCHANTMENTS;
    public static final IForgeRegistry<EntityType<?>> ENTITIES;
    public static final IForgeRegistry<BlockEntityType<?>> BLOCK_ENTITIES;
    public static final IForgeRegistry<ParticleType<?>> PARTICLE_TYPES;
    public static final IForgeRegistry<MenuType<?>> CONTAINERS;
    public static final IForgeRegistry<Motive> PAINTING_TYPES;
    public static final IForgeRegistry<RecipeSerializer<?>> RECIPE_SERIALIZERS;
    public static final IForgeRegistry<Attribute> ATTRIBUTES;
    public static final IForgeRegistry<StatType<?>> STAT_TYPES;
    public static final IForgeRegistry<VillagerProfession> PROFESSIONS;
    public static final IForgeRegistry<PoiType> POI_TYPES;
    public static final IForgeRegistry<MemoryModuleType<?>> MEMORY_MODULE_TYPES;
    public static final IForgeRegistry<SensorType<?>> SENSOR_TYPES;
    public static final IForgeRegistry<Schedule> SCHEDULES;
    public static final IForgeRegistry<Activity> ACTIVITIES;
    public static final IForgeRegistry<WorldCarver<?>> WORLD_CARVERS;
    public static final IForgeRegistry<Feature<?>> FEATURES;
    public static final IForgeRegistry<ChunkStatus> CHUNK_STATUS;
    public static final IForgeRegistry<StructureFeature<?>> STRUCTURE_FEATURES;
    public static final IForgeRegistry<BlockStateProviderType<?>> BLOCK_STATE_PROVIDER_TYPES;
    public static final IForgeRegistry<FoliagePlacerType<?>> FOLIAGE_PLACER_TYPES;
    public static final IForgeRegistry<TreeDecoratorType<?>> TREE_DECORATOR_TYPES;
    public static final IForgeRegistry<Biome> BIOMES;
    static final DeferredRegister<DataSerializerEntry> DEFERRED_DATA_SERIALIZERS;
    public static final Supplier<IForgeRegistry<DataSerializerEntry>> DATA_SERIALIZERS;
    static final DeferredRegister<GlobalLootModifierSerializer<?>> DEFERRED_LOOT_MODIFIER_SERIALIZERS;
    public static final Supplier<IForgeRegistry<GlobalLootModifierSerializer<?>>> LOOT_MODIFIER_SERIALIZERS;
    static final DeferredRegister<ForgeWorldPreset> DEFERRED_WORLD_TYPES;
    public static final Supplier<IForgeRegistry<ForgeWorldPreset>> WORLD_TYPES;

    private static void init() {
        Keys.init();
        GameData.init();
        Bootstrap.m_135870_();
        Tags.init();
    }

    static {
        ForgeRegistries.init();
        BLOCKS = RegistryManager.ACTIVE.getRegistry(Keys.BLOCKS);
        FLUIDS = RegistryManager.ACTIVE.getRegistry(Keys.FLUIDS);
        ITEMS = RegistryManager.ACTIVE.getRegistry(Keys.ITEMS);
        MOB_EFFECTS = RegistryManager.ACTIVE.getRegistry(Keys.MOB_EFFECTS);
        SOUND_EVENTS = RegistryManager.ACTIVE.getRegistry(Keys.SOUND_EVENTS);
        POTIONS = RegistryManager.ACTIVE.getRegistry(Keys.POTIONS);
        ENCHANTMENTS = RegistryManager.ACTIVE.getRegistry(Keys.ENCHANTMENTS);
        ENTITIES = RegistryManager.ACTIVE.getRegistry(Keys.ENTITY_TYPES);
        BLOCK_ENTITIES = RegistryManager.ACTIVE.getRegistry(Keys.BLOCK_ENTITY_TYPES);
        PARTICLE_TYPES = RegistryManager.ACTIVE.getRegistry(Keys.PARTICLE_TYPES);
        CONTAINERS = RegistryManager.ACTIVE.getRegistry(Keys.CONTAINER_TYPES);
        PAINTING_TYPES = RegistryManager.ACTIVE.getRegistry(Keys.PAINTING_TYPES);
        RECIPE_SERIALIZERS = RegistryManager.ACTIVE.getRegistry(Keys.RECIPE_SERIALIZERS);
        ATTRIBUTES = RegistryManager.ACTIVE.getRegistry(Keys.ATTRIBUTES);
        STAT_TYPES = RegistryManager.ACTIVE.getRegistry(Keys.STAT_TYPES);
        PROFESSIONS = RegistryManager.ACTIVE.getRegistry(Keys.VILLAGER_PROFESSIONS);
        POI_TYPES = RegistryManager.ACTIVE.getRegistry(Keys.POI_TYPES);
        MEMORY_MODULE_TYPES = RegistryManager.ACTIVE.getRegistry(Keys.MEMORY_MODULE_TYPES);
        SENSOR_TYPES = RegistryManager.ACTIVE.getRegistry(Keys.SENSOR_TYPES);
        SCHEDULES = RegistryManager.ACTIVE.getRegistry(Keys.SCHEDULES);
        ACTIVITIES = RegistryManager.ACTIVE.getRegistry(Keys.ACTIVITIES);
        WORLD_CARVERS = RegistryManager.ACTIVE.getRegistry(Keys.WORLD_CARVERS);
        FEATURES = RegistryManager.ACTIVE.getRegistry(Keys.FEATURES);
        CHUNK_STATUS = RegistryManager.ACTIVE.getRegistry(Keys.CHUNK_STATUS);
        STRUCTURE_FEATURES = RegistryManager.ACTIVE.getRegistry(Keys.STRUCTURE_FEATURES);
        BLOCK_STATE_PROVIDER_TYPES = RegistryManager.ACTIVE.getRegistry(Keys.BLOCK_STATE_PROVIDER_TYPES);
        FOLIAGE_PLACER_TYPES = RegistryManager.ACTIVE.getRegistry(Keys.FOLIAGE_PLACER_TYPES);
        TREE_DECORATOR_TYPES = RegistryManager.ACTIVE.getRegistry(Keys.TREE_DECORATOR_TYPES);
        BIOMES = RegistryManager.ACTIVE.getRegistry(Keys.BIOMES);
        DEFERRED_DATA_SERIALIZERS = DeferredRegister.create(Keys.DATA_SERIALIZERS, Keys.DATA_SERIALIZERS.m_135782_().m_135827_());
        DATA_SERIALIZERS = DEFERRED_DATA_SERIALIZERS.makeRegistry(DataSerializerEntry.class, GameData::getDataSerializersRegistryBuilder);
        DEFERRED_LOOT_MODIFIER_SERIALIZERS = DeferredRegister.create(Keys.LOOT_MODIFIER_SERIALIZERS, Keys.LOOT_MODIFIER_SERIALIZERS.m_135782_().m_135827_());
        LOOT_MODIFIER_SERIALIZERS = DEFERRED_LOOT_MODIFIER_SERIALIZERS.makeRegistry(GameData.c(GlobalLootModifierSerializer.class), GameData::getGLMSerializersRegistryBuilder);
        DEFERRED_WORLD_TYPES = DeferredRegister.create(Keys.WORLD_TYPES, Keys.WORLD_TYPES.m_135782_().m_135827_());
        WORLD_TYPES = DEFERRED_WORLD_TYPES.makeRegistry(ForgeWorldPreset.class, GameData::getWorldTypesRegistryBuilder);
    }

    public static final class Keys {
        public static final ResourceKey<Registry<Block>> BLOCKS = Keys.key("block");
        public static final ResourceKey<Registry<Fluid>> FLUIDS = Keys.key("fluid");
        public static final ResourceKey<Registry<Item>> ITEMS = Keys.key("item");
        public static final ResourceKey<Registry<MobEffect>> MOB_EFFECTS = Keys.key("mob_effect");
        public static final ResourceKey<Registry<Potion>> POTIONS = Keys.key("potion");
        public static final ResourceKey<Registry<Attribute>> ATTRIBUTES = Keys.key("attribute");
        public static final ResourceKey<Registry<StatType<?>>> STAT_TYPES = Keys.key("stat_type");
        public static final ResourceKey<Registry<SoundEvent>> SOUND_EVENTS = Keys.key("sound_event");
        public static final ResourceKey<Registry<Enchantment>> ENCHANTMENTS = Keys.key("enchantment");
        public static final ResourceKey<Registry<EntityType<?>>> ENTITY_TYPES = Keys.key("entity_type");
        public static final ResourceKey<Registry<Motive>> PAINTING_TYPES = Keys.key("motive");
        public static final ResourceKey<Registry<ParticleType<?>>> PARTICLE_TYPES = Keys.key("particle_type");
        public static final ResourceKey<Registry<MenuType<?>>> CONTAINER_TYPES = Keys.key("menu");
        public static final ResourceKey<Registry<BlockEntityType<?>>> BLOCK_ENTITY_TYPES = Keys.key("block_entity_type");
        public static final ResourceKey<Registry<RecipeSerializer<?>>> RECIPE_SERIALIZERS = Keys.key("recipe_serializer");
        public static final ResourceKey<Registry<VillagerProfession>> VILLAGER_PROFESSIONS = Keys.key("villager_profession");
        public static final ResourceKey<Registry<PoiType>> POI_TYPES = Keys.key("point_of_interest_type");
        public static final ResourceKey<Registry<MemoryModuleType<?>>> MEMORY_MODULE_TYPES = Keys.key("memory_module_type");
        public static final ResourceKey<Registry<SensorType<?>>> SENSOR_TYPES = Keys.key("sensor_type");
        public static final ResourceKey<Registry<Schedule>> SCHEDULES = Keys.key("schedule");
        public static final ResourceKey<Registry<Activity>> ACTIVITIES = Keys.key("activity");
        public static final ResourceKey<Registry<WorldCarver<?>>> WORLD_CARVERS = Keys.key("worldgen/carver");
        public static final ResourceKey<Registry<Feature<?>>> FEATURES = Keys.key("worldgen/feature");
        public static final ResourceKey<Registry<ChunkStatus>> CHUNK_STATUS = Keys.key("chunk_status");
        public static final ResourceKey<Registry<StructureFeature<?>>> STRUCTURE_FEATURES = Keys.key("worldgen/structure_feature");
        public static final ResourceKey<Registry<BlockStateProviderType<?>>> BLOCK_STATE_PROVIDER_TYPES = Keys.key("worldgen/block_state_provider_type");
        public static final ResourceKey<Registry<FoliagePlacerType<?>>> FOLIAGE_PLACER_TYPES = Keys.key("worldgen/foliage_placer_type");
        public static final ResourceKey<Registry<TreeDecoratorType<?>>> TREE_DECORATOR_TYPES = Keys.key("worldgen/tree_decorator_type");
        public static final ResourceKey<Registry<Biome>> BIOMES = Keys.key("worldgen/biome");
        public static final ResourceKey<Registry<DataSerializerEntry>> DATA_SERIALIZERS = Keys.key("data_serializers");
        public static final ResourceKey<Registry<GlobalLootModifierSerializer<?>>> LOOT_MODIFIER_SERIALIZERS = Keys.key("forge:loot_modifier_serializers");
        public static final ResourceKey<Registry<ForgeWorldPreset>> WORLD_TYPES = Keys.key("forge:world_types");

        private static <T> ResourceKey<Registry<T>> key(String name) {
            return ResourceKey.m_135788_((ResourceLocation)new ResourceLocation(name));
        }

        private static void init() {
        }
    }
}

